/*
http://downloads.sourceforge.net/filezilla/FileZilla_3.10.2_win32.zip
http://downloads.sourceforge.net/filezilla/FileZilla_3.10.3-rc1_win32.zip
http://downloads.sourceforge.net/filezilla/FileZilla_3.10.3-rc1_win64.zip
*/
!define RELEASURL	"http://downloads.sourceforge.net/filezilla"
!define APPSIZE	"13800" # kB
!define DLVER	"MultiVersion"
!define APPVER 	"0.0.0.0"
!define APPNAME "FileZilla"
!define APP 	"FileZilla"
!define DLNAME	"FileZilla"
!define APPLANG	"32-64-bit_Multilingual_Online"
!define FOLDER	"FileZillaPortable"
!define FINISHRUN ; Delete if not Finish pages
!define OPTIONS ; Delete if no Components
!define SOURCES ; Delete if no Sources
; !define DESCRIPTION	"Fast and reliable cross-platform FTP, FTPS and SFTP client" ; Delete if no AppInfo
!define INPUTBOX ; Delete if no InputBox

SetCompressor /SOLID lzma
SetCompressorDictSize 32
!include "LogicLib.nsh"
!include "x64.nsh"

!include "..\_Include\Installer.nsh"

!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Arabic"
!insertmacro MUI_LANGUAGE "Bulgarian"
!insertmacro MUI_LANGUAGE "Catalan"
!insertmacro MUI_LANGUAGE "Czech"
!insertmacro MUI_LANGUAGE "Danish"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Greek"
!insertmacro MUI_LANGUAGE "SpanishInternational"
!insertmacro MUI_LANGUAGE "Estonian"
!insertmacro MUI_LANGUAGE "Basque"
!insertmacro MUI_LANGUAGE "Farsi"
!insertmacro MUI_LANGUAGE "Finnish"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Galician"
!insertmacro MUI_LANGUAGE "Hebrew"
!insertmacro MUI_LANGUAGE "Croatian"
!insertmacro MUI_LANGUAGE "Hungarian"
!insertmacro MUI_LANGUAGE "Indonesian"
!insertmacro MUI_LANGUAGE "Icelandic"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "Japanese"
!insertmacro MUI_LANGUAGE "Korean"
!insertmacro MUI_LANGUAGE "Lithuanian"
!insertmacro MUI_LANGUAGE "Latvian"
!insertmacro MUI_LANGUAGE "Macedonian"
!insertmacro MUI_LANGUAGE "Mongolian"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "NorwegianNynorsk"
; !insertmacro MUI_LANGUAGE "Occitan"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "Portuguese"
!insertmacro MUI_LANGUAGE "Romanian"
!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Slovak"
!insertmacro MUI_LANGUAGE "Slovenian"
!insertmacro MUI_LANGUAGE "Serbian"
!insertmacro MUI_LANGUAGE "Swedish"
!insertmacro MUI_LANGUAGE "Thai"
!insertmacro MUI_LANGUAGE "Turkish"
!insertmacro MUI_LANGUAGE "Ukrainian"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "TradChinese"

Var InputVer
Var VER
Function nsDialogsPage
	nsDialogs::Create 1018
	Pop $0
	${NSD_CreateLabel} 0 0 100% 12u "Enter Version Number:"
	Pop $0
	${NSD_CreateText} 0 13u 100% 12u ""
	Pop $InputVer
	nsDialogs::Show
FunctionEnd
Function nsDialogsPageLeave
	${NSD_GetText} $InputVer $R0
StrCmp $R0 "" 0 +3
	MessageBox MB_ICONEXCLAMATION `You must enter a version number!`
Abort
	StrCpy $VER "$R0"
FunctionEnd

Section "${APPNAME} Portable English 32 bit" main

Call CheckConnected
	inetc::get "${RELEASURL}/FileZilla_$VER_win32.zip" "$TEMP\${APP}PortableTemp\FileZilla_$VER_win32.zip" /END
	Pop $0 # return value = exit code, "OK" if OK
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of FileZilla_$VER_win32.zip: $0"
	Abort
	File "/oname=$TEMP\${APP}PortableTemp\7za.exe" "..\_Include\7-Zip\7za.exe"
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7za.exe" x "$TEMP\${APP}PortableTemp\FileZilla_$VER_win32.zip" -aoa -o"$TEMP\${APP}PortableTemp"`
DetailPrint "Installing ${APPNAME} Portable 32 bit"

	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
	Delete "$TEMP\${APP}PortableTemp\${APP}-$VER\fzshellext.dll"
	Delete "$TEMP\${APP}PortableTemp\${APP}-$VER\fzshellext_64.dll"
	Rename "$TEMP\${APP}PortableTemp\${APP}-$VER\locales" "$TEMP\${APP}PortableTemp\locales"

	SetOutPath "$INSTDIR\App\${APP}"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}-$VER\*.*" "$INSTDIR\App\${APP}"

!ifdef DESCRIPTION
Call AppInfo
!endif
!ifdef SOURCES
Call Sources
	SetOutPath "$INSTDIR\Other\_Include\7-Zip"
	File "..\_Include\7-Zip\7za.exe"
!endif
!ifdef SOURCES & DESCRIPTION
Call SourceInfo
!endif

cancelled:
SectionEnd

Function .onGUIEnd
	RMDir "/r" "$TEMP\${APP}PortableTemp"
FunctionEnd

Section /o "${APPNAME} Portable English 64 bit" x64
Call CheckConnected
	inetc::get "${RELEASURL}/FileZilla_$VER_win64.zip" "$TEMP\${APP}PortableTemp\FileZilla_$VER_win64.zip" /END
	Pop $0 # return value = exit code, "OK" if OK
StrCmp $0 "OK" +3
	MessageBox MB_USERICON "Download of FileZilla_$VER_win64.zip: $0"
	Abort
	RMDir "/r" "$TEMP\${APP}-$VER"
	File "/oname=$TEMP\${APP}PortableTemp\7za.exe" "..\_Include\7-Zip\7za.exe"
	nsExec::Exec `"$TEMP\${APP}PortableTemp\7za.exe" x "$TEMP\${APP}PortableTemp\FileZilla_$VER_win64.zip" -aoa -o"$TEMP\${APP}PortableTemp"`
DetailPrint "Installing ${APPNAME} Portable 64 bit"

	SetOutPath "$INSTDIR"
		File "..\..\..\${FOLDER}\${APP}Portable.exe"
	Delete "$TEMP\${APP}PortableTemp\${APP}-$VER\fzshellext.dll"
	Delete "$TEMP\${APP}PortableTemp\${APP}-$VER\fzshellext_64.dll"
	Rename "$TEMP\${APP}PortableTemp\${APP}-$VER\locales" "$TEMP\${APP}PortableTemp\locales64"

	SetOutPath "$INSTDIR\App\${APP}"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}-$VER\*.*" "$INSTDIR\App\${APP}64"

SectionEnd

SectionGroup "Language"

Section /o "Arabic" ar
	SetOutPath "$INSTDIR\App\${APP}\locales\ar"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\ar\*.*" "$INSTDIR\App\${APP}\locales\ar"
	SetOutPath "$INSTDIR\App\${APP}64\locales\ar"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\ar\*.*" "$INSTDIR\App\${APP}64\locales\ar"
SectionEnd

Section /o "Bulgarian" bg_BG
	SetOutPath "$INSTDIR\App\${APP}\locales\bg_BG"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\bg_BG\*.*" "$INSTDIR\App\${APP}\locales\bg_BG"
	SetOutPath "$INSTDIR\App\${APP}64\locales\bg_BG"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\bg_BG\*.*" "$INSTDIR\App\${APP}64\locales\bg_BG"
SectionEnd

Section /o "Catalan" ca
	SetOutPath "$INSTDIR\App\${APP}\locales\ca"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\ca\*.*" "$INSTDIR\App\${APP}\locales\ca"
	SetOutPath "$INSTDIR\App\${APP}64\locales\ca"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\ca\*.*" "$INSTDIR\App\${APP}64\locales\ca"
SectionEnd

Section /o "Czech" cs_CZ
	SetOutPath "$INSTDIR\App\${APP}\locales\cs_CZ"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\cs_CZ\*.*" "$INSTDIR\App\${APP}\locales\cs_CZ"
	SetOutPath "$INSTDIR\App\${APP}64\locales\cs_CZ"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\cs_CZ\*.*" "$INSTDIR\App\${APP}64\locales\cs_CZ"
SectionEnd

Section /o "Danish" da_DK
	SetOutPath "$INSTDIR\App\${APP}\locales\da_DK"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\da_DK\*.*" "$INSTDIR\App\${APP}\locales\da_DK"
	SetOutPath "$INSTDIR\App\${APP}64\locales\da_DK"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\da_DK\*.*" "$INSTDIR\App\${APP}64\locales\da_DK"
SectionEnd

Section /o "German" de
	SetOutPath "$INSTDIR\App\${APP}\locales\de"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\de\*.*" "$INSTDIR\App\${APP}\locales\de"
	SetOutPath "$INSTDIR\App\${APP}64\locales\de"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\de\*.*" "$INSTDIR\App\${APP}64\locales\de"
SectionEnd

Section /o "Greek" el
	SetOutPath "$INSTDIR\App\${APP}\locales\el"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\el\*.*" "$INSTDIR\App\${APP}\locales\el"
	SetOutPath "$INSTDIR\App\${APP}64\locales\el"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\el\*.*" "$INSTDIR\App\${APP}64\locales\el"
SectionEnd

Section /o "SpanishInternational" es
	SetOutPath "$INSTDIR\App\${APP}\locales\es"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\es\*.*" "$INSTDIR\App\${APP}\locales\es"
	SetOutPath "$INSTDIR\App\${APP}64\locales\es"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\es\*.*" "$INSTDIR\App\${APP}64\locales\es"
SectionEnd

Section /o "Estonian" et_EE
	SetOutPath "$INSTDIR\App\${APP}\locales\et_EE"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\et_EE\*.*" "$INSTDIR\App\${APP}\locales\et_EE"
	SetOutPath "$INSTDIR\App\${APP}64\locales\et_EE"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\et_EE\*.*" "$INSTDIR\App\${APP}64\locales\et_EE"
SectionEnd

Section /o "Basque" eu_ES
	SetOutPath "$INSTDIR\App\${APP}\locales\eu_ES"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\eu_ES\*.*" "$INSTDIR\App\${APP}\locales\eu_ES"
	SetOutPath "$INSTDIR\App\${APP}64\locales\eu_ES"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\eu_ES\*.*" "$INSTDIR\App\${APP}64\locales\eu_ES"
SectionEnd

Section /o "Farsi" fa_IR
	SetOutPath "$INSTDIR\App\${APP}\locales\fa_IR"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\fa_IR\*.*" "$INSTDIR\App\${APP}\locales\fa_IR"
	SetOutPath "$INSTDIR\App\${APP}64\locales\fa_IR"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\fa_IR\*.*" "$INSTDIR\App\${APP}64\locales\fa_IR"
SectionEnd

Section /o "Finnish" fi_FI
	SetOutPath "$INSTDIR\App\${APP}\locales\fi_FI"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\fi_FI\*.*" "$INSTDIR\App\${APP}\locales\fi_FI"
	SetOutPath "$INSTDIR\App\${APP}64\locales\fi_FI"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\fi_FI\*.*" "$INSTDIR\App\${APP}64\locales\fi_FI"
SectionEnd

Section /o "French" fr
	SetOutPath "$INSTDIR\App\${APP}\locales\fr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\fr\*.*" "$INSTDIR\App\${APP}\locales\fr"
	SetOutPath "$INSTDIR\App\${APP}64\locales\fr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\fr\*.*" "$INSTDIR\App\${APP}64\locales\fr"
SectionEnd

Section /o "Galician" gl_ES
	SetOutPath "$INSTDIR\App\${APP}\locales\gl_ES"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\gl_ES\*.*" "$INSTDIR\App\${APP}\locales\gl_ES"
	SetOutPath "$INSTDIR\App\${APP}64\locales\gl_ES"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\gl_ES\*.*" "$INSTDIR\App\${APP}64\locales\gl_ES"
SectionEnd

Section /o "Hebrew" he_IL
	SetOutPath "$INSTDIR\App\${APP}\locales\he_IL"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\he_IL\*.*" "$INSTDIR\App\${APP}\locales\he_IL"
	SetOutPath "$INSTDIR\App\${APP}64\locales\he_IL"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\he_IL\*.*" "$INSTDIR\App\${APP}64\locales\he_IL"
SectionEnd

Section /o "Croatian" hr
	SetOutPath "$INSTDIR\App\${APP}\locales\hr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\hr\*.*" "$INSTDIR\App\${APP}\locales\hr"
	SetOutPath "$INSTDIR\App\${APP}64\locales\hr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\hr\*.*" "$INSTDIR\App\${APP}64\locales\hr"
SectionEnd

Section /o "Hungarian" hu_HU
	SetOutPath "$INSTDIR\App\${APP}\locales\hu_HU"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\hu_HU\*.*" "$INSTDIR\App\${APP}\locales\hu_HU"
	SetOutPath "$INSTDIR\App\${APP}64\locales\hu_HU"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\hu_HU\*.*" "$INSTDIR\App\${APP}64\locales\hu_HU"
SectionEnd

Section /o "Indonesian" id_ID
	SetOutPath "$INSTDIR\App\${APP}\locales\id_ID"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\id_ID\*.*" "$INSTDIR\App\${APP}\locales\id_ID"
	SetOutPath "$INSTDIR\App\${APP}64\locales\id_ID"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\id_ID\*.*" "$INSTDIR\App\${APP}64\locales\id_ID"
SectionEnd

Section /o "Icelandic" is
	SetOutPath "$INSTDIR\App\${APP}\locales\is"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\is\*.*" "$INSTDIR\App\${APP}\locales\is"
	SetOutPath "$INSTDIR\App\${APP}64\locales\is"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\is\*.*" "$INSTDIR\App\${APP}64\locales\is"
SectionEnd

Section /o "Italian" it
	SetOutPath "$INSTDIR\App\${APP}\locales\it"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\it\*.*" "$INSTDIR\App\${APP}\locales\it"
	SetOutPath "$INSTDIR\App\${APP}64\locales\it"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\it\*.*" "$INSTDIR\App\${APP}64\locales\it"
SectionEnd

Section /o "Japanese" ja_JP
	SetOutPath "$INSTDIR\App\${APP}\locales\ja_JP"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\ja_JP\*.*" "$INSTDIR\App\${APP}\locales\ja_JP"
	SetOutPath "$INSTDIR\App\${APP}64\locales\ja_JP"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\ja_JP\*.*" "$INSTDIR\App\${APP}64\locales\ja_JP"
SectionEnd

Section /o "Korean" ko_KR
	SetOutPath "$INSTDIR\App\${APP}\locales\ko_KR"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\ko_KR\*.*" "$INSTDIR\App\${APP}\locales\ko_KR"
	SetOutPath "$INSTDIR\App\${APP}64\locales\ko_KR"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\ko_KR\*.*" "$INSTDIR\App\${APP}64\locales\ko_KR"
SectionEnd

Section /o "Lithuanian" lt_LT
	SetOutPath "$INSTDIR\App\${APP}\locales\lt_LT"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\lt_LT\*.*" "$INSTDIR\App\${APP}\locales\lt_LT"
	SetOutPath "$INSTDIR\App\${APP}64\locales\lt_LT"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\lt_LT\*.*" "$INSTDIR\App\${APP}64\locales\lt_LT"
SectionEnd

Section /o "Latvian" lv_LV
	SetOutPath "$INSTDIR\App\${APP}\locales\lv_LV"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\lv_LV\*.*" "$INSTDIR\App\${APP}\locales\lv_LV"
	SetOutPath "$INSTDIR\App\${APP}64\locales\lv_LV"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\lv_LV\*.*" "$INSTDIR\App\${APP}64\locales\lv_LV"
SectionEnd

Section /o "Macedonian" mk_MK
	SetOutPath "$INSTDIR\App\${APP}\locales\mk_MK"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\mk_MK\*.*" "$INSTDIR\App\${APP}\locales\mk_MK"
	SetOutPath "$INSTDIR\App\${APP}64\locales\mk_MK"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\mk_MK\*.*" "$INSTDIR\App\${APP}64\locales\mk_MK"
SectionEnd

Section /o "Mongolian" nb_NO
	SetOutPath "$INSTDIR\App\${APP}\locales\nb_NO"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\nb_NO\*.*" "$INSTDIR\App\${APP}\locales\nb_NO"
	SetOutPath "$INSTDIR\App\${APP}64\locales\nb_NO"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\nb_NO\*.*" "$INSTDIR\App\${APP}64\locales\nb_NO"
SectionEnd

Section /o "Dutch" nl
	SetOutPath "$INSTDIR\App\${APP}\locales\nl"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\nl\*.*" "$INSTDIR\App\${APP}\locales\nl"
	SetOutPath "$INSTDIR\App\${APP}64\locales\nl"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\nl\*.*" "$INSTDIR\App\${APP}64\locales\nl"
SectionEnd

Section /o "NorwegianNynorsk" nn_NO
	SetOutPath "$INSTDIR\App\${APP}\locales\nn_NO"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\nn_NO\*.*" "$INSTDIR\App\${APP}\locales\nn_NO"
	SetOutPath "$INSTDIR\App\${APP}64\locales\nn_NO"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\nn_NO\*.*" "$INSTDIR\App\${APP}64\locales\nn_NO"
SectionEnd

Section /o "Occitan" oc
	SetOutPath "$INSTDIR\App\${APP}\locales\oc"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\oc\*.*" "$INSTDIR\App\${APP}\locales\oc"
	SetOutPath "$INSTDIR\App\${APP}64\locales\oc"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\oc\*.*" "$INSTDIR\App\${APP}64\locales\oc"
SectionEnd

Section /o "Polish" pl_PL
	SetOutPath "$INSTDIR\App\${APP}\locales\pl_PL"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\pl_PL\*.*" "$INSTDIR\App\${APP}\locales\pl_PL"
	SetOutPath "$INSTDIR\App\${APP}64\locales\pl_PL"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\pl_PL\*.*" "$INSTDIR\App\${APP}64\locales\pl_PL"
SectionEnd

Section /o "PortugueseBR" pt_BR
	SetOutPath "$INSTDIR\App\${APP}\locales\pt_BR"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\pt_BR\*.*" "$INSTDIR\App\${APP}\locales\pt_BR"
	SetOutPath "$INSTDIR\App\${APP}64\locales\pt_BR"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\pt_BR\*.*" "$INSTDIR\App\${APP}64\locales\pt_BR"
SectionEnd

Section /o "Portuguese" pt_PT
	SetOutPath "$INSTDIR\App\${APP}\locales\pt_PT"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\pt_PT\*.*" "$INSTDIR\App\${APP}\locales\pt_PT"
	SetOutPath "$INSTDIR\App\${APP}64\locales\pt_PT"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\pt_PT\*.*" "$INSTDIR\App\${APP}64\locales\pt_PT"
SectionEnd

Section /o "Romanian" ro_RO
	SetOutPath "$INSTDIR\App\${APP}\locales\ro_RO"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\ro_RO\*.*" "$INSTDIR\App\${APP}\locales\ro_RO"
	SetOutPath "$INSTDIR\App\${APP}64\locales\ro_RO"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\ro_RO\*.*" "$INSTDIR\App\${APP}64\locales\ro_RO"
SectionEnd

Section /o "Russian" ru
	SetOutPath "$INSTDIR\App\${APP}\locales\ru"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\ru\*.*" "$INSTDIR\App\${APP}\locales\ru"
	SetOutPath "$INSTDIR\App\${APP}64\locales\ru"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\ru\*.*" "$INSTDIR\App\${APP}64\locales\ru"
SectionEnd

Section /o "Slovak" sk_SK
	SetOutPath "$INSTDIR\App\${APP}\locales\sk_SK"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\sk_SK\*.*" "$INSTDIR\App\${APP}\locales\sk_SK"
	SetOutPath "$INSTDIR\App\${APP}64\locales\sk_SK"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\sk_SK\*.*" "$INSTDIR\App\${APP}64\locales\sk_SK"
SectionEnd

Section /o "Slovenian" sl_SI
	SetOutPath "$INSTDIR\App\${APP}\locales\sl_SI"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\sl_SI\*.*" "$INSTDIR\App\${APP}\locales\sl_SI"
	SetOutPath "$INSTDIR\App\${APP}64\locales\sl_SI"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\sl_SI\*.*" "$INSTDIR\App\${APP}64\locales\sl_SI"
SectionEnd

Section /o "Serbian" sr
	SetOutPath "$INSTDIR\App\${APP}\locales\sr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\sr\*.*" "$INSTDIR\App\${APP}\locales\sr"
	SetOutPath "$INSTDIR\App\${APP}64\locales\sr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\sr\*.*" "$INSTDIR\App\${APP}64\locales\sr"
SectionEnd

Section /o "Swedish" sv
	SetOutPath "$INSTDIR\App\${APP}\locales\sv"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\sv\*.*" "$INSTDIR\App\${APP}\locales\sv"
	SetOutPath "$INSTDIR\App\${APP}64\locales\sv"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\sv\*.*" "$INSTDIR\App\${APP}64\locales\sv"
SectionEnd

Section /o "Thai" th_TH
	SetOutPath "$INSTDIR\App\${APP}\locales\th_TH"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\th_TH\*.*" "$INSTDIR\App\${APP}\locales\th_TH"
	SetOutPath "$INSTDIR\App\${APP}64\locales\th_TH"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\th_TH\*.*" "$INSTDIR\App\${APP}64\locales\th_TH"
SectionEnd

Section /o "Turkish" tr
	SetOutPath "$INSTDIR\App\${APP}\locales\tr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\tr\*.*" "$INSTDIR\App\${APP}\locales\tr"
	SetOutPath "$INSTDIR\App\${APP}64\locales\tr"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\tr\*.*" "$INSTDIR\App\${APP}64\locales\tr"
SectionEnd

Section /o "Ukrainian" uk_UA
	SetOutPath "$INSTDIR\App\${APP}\locales\uk_UA"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\uk_UA\*.*" "$INSTDIR\App\${APP}\locales\uk_UA"
	SetOutPath "$INSTDIR\App\${APP}64\locales\uk_UA"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\uk_UA\*.*" "$INSTDIR\App\${APP}64\locales\uk_UA"
SectionEnd

Section /o "SimpChinese" zh_CN
	SetOutPath "$INSTDIR\App\${APP}\locales\zh_CN"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\zh_CN\*.*" "$INSTDIR\App\${APP}\locales\zh_CN"
	SetOutPath "$INSTDIR\App\${APP}64\locales\zh_CN"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\zh_CN\*.*" "$INSTDIR\App\${APP}64\locales\zh_CN"
SectionEnd

Section /o "TradChinese" zh_TW
	SetOutPath "$INSTDIR\App\${APP}\locales\zh_TW"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales\zh_TW\*.*" "$INSTDIR\App\${APP}\locales\zh_TW"
	SetOutPath "$INSTDIR\App\${APP}64\locales\zh_TW"
	CopyFiles /SILENT "$TEMP\${APP}PortableTemp\locales64\zh_TW\*.*" "$INSTDIR\App\${APP}64\locales\zh_TW"
SectionEnd

SectionGroupEnd

Function Init
SectionSetSize ${ar} 300 # kB
SectionSetSize ${bg_BG} 300 # kB
SectionSetSize ${ca} 300 # kB
SectionSetSize ${cs_CZ} 300 # kB
SectionSetSize ${da_DK} 300 # kB
SectionSetSize ${de} 300 # kB
SectionSetSize ${el} 300 # kB
SectionSetSize ${es} 300 # kB
SectionSetSize ${et_EE} 300 # kB
SectionSetSize ${eu_ES} 300 # kB
SectionSetSize ${fa_IR} 300 # kB
SectionSetSize ${fi_FI} 300 # kB
SectionSetSize ${fr} 300 # kB
SectionSetSize ${gl_ES} 300 # kB
SectionSetSize ${he_IL} 300 # kB
SectionSetSize ${hr} 300 # kB
SectionSetSize ${hu_HU} 300 # kB
SectionSetSize ${id_ID} 300 # kB
SectionSetSize ${is} 300 # kB
SectionSetSize ${it} 300 # kB
SectionSetSize ${ja_JP} 300 # kB
SectionSetSize ${ko_KR} 300 # kB
SectionSetSize ${lt_LT} 300 # kB
SectionSetSize ${lv_LV} 300 # kB
SectionSetSize ${mk_MK} 300 # kB
SectionSetSize ${nb_NO} 300 # kB
SectionSetSize ${nl} 300 # kB
SectionSetSize ${nn_NO} 300 # kB
SectionSetSize ${oc} 300 # kB
SectionSetSize ${pl_PL} 300 # kB
SectionSetSize ${pt_BR} 300 # kB
SectionSetSize ${pt_PT} 300 # kB
SectionSetSize ${ro_RO} 300 # kB
SectionSetSize ${ru} 300 # kB
SectionSetSize ${sk_SK} 300 # kB
SectionSetSize ${sl_SI} 300 # kB
SectionSetSize ${sr} 300 # kB
SectionSetSize ${sv} 300 # kB
SectionSetSize ${th_TH} 300 # kB
SectionSetSize ${tr} 300 # kB
SectionSetSize ${uk_UA} 300 # kB
SectionSetSize ${zh_CN} 300 # kB
SectionSetSize ${zh_TW} 300 # kB

System::Call 'kernel32::GetUserDefaultLangID() i .r0'
StrCmp $0 "1025" 0 +2
SectionSetFlags ${ar} 1
StrCmp $0 "1026" 0 +2
SectionSetFlags ${bg_BG} 1
StrCmp $0 "1027" 0 +2
SectionSetFlags ${ca} 1
StrCmp $0 "1029" 0 +2
SectionSetFlags ${cs_CZ} 1
StrCmp $0 "1030" 0 +2
SectionSetFlags ${da_DK} 1
StrCmp $0 "1031" 0 +2
SectionSetFlags ${de} 1
StrCmp $0 "1032" 0 +2
SectionSetFlags ${el} 1
StrCmp $0 "3082" 0 +2
SectionSetFlags ${es} 1
StrCmp $0 "1061" 0 +2
SectionSetFlags ${et_EE} 1
StrCmp $0 "1069" 0 +2
SectionSetFlags ${eu_ES} 1
StrCmp $0 "1065" 0 +2
SectionSetFlags ${fa_IR} 1
StrCmp $0 "1035" 0 +2
SectionSetFlags ${fi_FI} 1
StrCmp $0 "1036" 0 +2
SectionSetFlags ${fr} 1
StrCmp $0 "1110" 0 +2
SectionSetFlags ${gl_ES} 1
StrCmp $0 "1037" 0 +2
SectionSetFlags ${he_IL} 1
StrCmp $0 "1050" 0 +2
SectionSetFlags ${hr} 1
StrCmp $0 "1038" 0 +2
SectionSetFlags ${hu_HU} 1
StrCmp $0 "1057" 0 +2
SectionSetFlags ${id_ID} 1
StrCmp $0 "15" 0 +2
SectionSetFlags ${is} 1
StrCmp $0 "1040" 0 +2
SectionSetFlags ${it} 1
StrCmp $0 "1041" 0 +2
SectionSetFlags ${ja_JP} 1
StrCmp $0 "1042" 0 +2
SectionSetFlags ${ko_KR} 1
StrCmp $0 "1063" 0 +2
SectionSetFlags ${lt_LT} 1
StrCmp $0 "1062" 0 +2
SectionSetFlags ${lv_LV} 1
StrCmp $0 "1071" 0 +2
SectionSetFlags ${mk_MK} 1
StrCmp $0 "1104" 0 +2
SectionSetFlags ${nb_NO} 1
StrCmp $0 "1043" 0 +2
SectionSetFlags ${nl} 1
StrCmp $0 "2068" 0 +2
SectionSetFlags ${nn_NO} 1
StrCmp $0 "1154" 0 +2
SectionSetFlags ${oc} 1
StrCmp $0 "1045" 0 +2
SectionSetFlags ${pl_PL} 1
StrCmp $0 "1046" 0 +2
SectionSetFlags ${pt_BR} 1
StrCmp $0 "2070" 0 +2
SectionSetFlags ${pt_PT} 1
StrCmp $0 "1048" 0 +2
SectionSetFlags ${ro_RO} 1
StrCmp $0 "1049" 0 +2
SectionSetFlags ${ru} 1
StrCmp $0 "1051" 0 +2
SectionSetFlags ${sk_SK} 1
StrCmp $0 "1060" 0 +2
SectionSetFlags ${sl_SI} 1
StrCmp $0 "3098" 0 +2
SectionSetFlags ${sr} 1
StrCmp $0 "1053" 0 +2
SectionSetFlags ${sv} 1
StrCmp $0 "1054" 0 +2
SectionSetFlags ${th_TH} 1
StrCmp $0 "1055" 0 +2
SectionSetFlags ${tr} 1
StrCmp $0 "1058" 0 +2
SectionSetFlags ${uk_UA} 1
StrCmp $0 "2052" 0 +2
SectionSetFlags ${zh_CN} 1
StrCmp $0 "1028" 0 +2
SectionSetFlags ${zh_TW} 1

SectionSetSize ${x64} 13400 # kB
${If} ${RunningX64}
SectionSetFlags ${x64} 1
${Else}
${EndIf}
FunctionEnd
