$policy=New-WBPolicy

$date = get-date -format "yyyy-MM-dd"

$ToDeleteLimit = (Get-Date).AddMonths(-3)

$basePath = "\\nasip\backup-windows\WindowsBackup\"


$targetpath = $basePath  + $date

New-Item -Path $targetpath -ItemType directory


Get-ChildItem -Path $basePath -Recurse -Force | Where-Object { $_.LastWriteTime -lt $ToDeleteLimit } | Remove-Item -Force


$BackupTargetVolume=New-WBbackupTarget -NetworkPath $targetpath

Add-WBBackupTarget -Policy $policy -Target $BackupTargetVolume

Add-WBBareMetalRecovery -Policy $policy

Add-WBSystemState -Policy $policy

Start-WBBackup -Policy $policy -Force