#!/bin/bash

##############################################
#매월 2일 전달 로그 폴더 압축 및 기존폴더 삭제
#crontab 등록
##############################################

##########날짜 설정##############
ZIP_MONTH=1
RM_MONTH=7


##########로그 파일명 설정#######
LOGDIR[0]=/web/logs/access_log
LOGDIR[1]=/web/logs/error_log
LOGDIR[2]=/web/logs/ssl_log

##########적용할 로그 갯수#######
COUNT=3


##############################################

#압축할 로그 날짜setting
CUR_YEAR=$(date -d $ZIP_MONTH' month ago' +%Y)
CUR_MONTH=$(date -d $ZIP_MONTH' month ago' +%m)

#삭제할 로그 날짜setting
DEL_YEAR=$(date -d $RM_MONTH' month ago' +%Y)
DEL_MONTH=$(date -d $RM_MONTH' month ago' +%m)



echo "압축할 로그"
echo $CUR_YEAR$CUR_MONTH

echo "삭제할 로그"
echo $DEL_YEAR$DEL_MONTH

echo "--------시작----------"

for ((i=0;i<$COUNT;i=i+1))
 do
  cd ${LOGDIR[${i}]}
  echo "cd ${LOGDIR[${i}]}"

  ################################
echo "압축"
 /usr/bin/find . -type d -name "$CUR_YEAR$CUR_MONTH" -exec /bin/tar -cvzf {}.tar.gz {} \; 2> /dev/null
echo "기존폴더 삭제" 
 /usr/bin/find . -type d -name "$CUR_YEAR$CUR_MONTH" -exec /bin/rm -rf {} \; 2> /dev/null
echo "오래된 압축파일 삭제"
 /usr/bin/find . -type f -name "$DEL_YEAR$DEL_MONTH.tar.gz" -exec /bin/rm -rf {} \; 2> /dev/null
done

echo "---------종료--------"
