#!/bin/bash
##############################################
# 작성일자  : 2020.04.10
# 내   용 : 설정한 로그 폴더 압축 및 기존폴더 삭제
#          오래된 압축파일 삭제
# 사용 설명
# ZIP_BASE : 압축대상 날짜 (달)
# DEL_MONTH : 삭제할 압축파일 날짜 (달)
# LOGDIR : 로그 파일 위치
# BACKDIR : 이동할 압축파일 위치
# TARGET : 로그 종류별로 수량 만큼 추가
# crontab 등록 (예시 : 매월 2일 00시 05분에 실행하며 실행로그 남김)
# 05 00 02 * * bash /쉘스크립트파일경로/httpd_log_clean.sh >> 로그경로 2>&1
##############################################
##############################################
##############################################
##############################################

#####################날짜 설정###################
ZIP_MONTH=2
DEL_MONTH=7

#################로그 파일명 설정##################
LOGDIR=/web/log/
BACKDIR=/backup/
TARGET=("access_log" "error_log" "ssl_log")
JOBLOG=/web/manager/

##############################################

#압축할 로그 날짜setting
ZIP_BASE=$(date -d $ZIP_MONTH' month ago' +%Y%m)
DEL_BASE=$(date -d $DEL_MONTH' month ago' +%Y%m)

#기본 폴더 생성
mkdir -p $JOBLOG

#현재시간
TODAY=$(date "+%Y-%m-%d  %H:%M:%S")
echo "-----------------------시작-----------------------"
echo "압축 파일 대상 : ${ZIP_BASE} 이전 날짜"
echo "삭제 파일 대상 : ${DEL_BASE} 이전 날짜"

echo "${TODAY} - 압축 작업 시작"
for ((i = 0 ; i < ${#TARGET[@]} ; i++ )) ; do

	#기본 폴더 생성
	mkdir -p $BACKDIR${TARGET[${i}]}

    echo "#######$LOGDIR${TARGET[${i}]}#######"
	list=(`ls -l $LOGDIR${TARGET[${i}]} | awk '{print$9}' | sort`)
	echo "파일 갯수 : ${#list[@]}"
	
		
	cd $LOGDIR${TARGET[${i}]}/
		
	for ((j = 0 ; j < ${#list[@]} ; j++ )) ; do
	
		
		if [ ${list[${j}]} -le $ZIP_BASE ]
		then
			echo "${TODAY} - ${TARGET[${i}]}/${list[${j}]} 압축중..."
			echo "${TODAY} - /bin/tar -cvzf ${list[${j}]}.tar.gz ${list[${j}]}" >> ${JOBLOG}manage.log
			/bin/tar -cvzf ${list[${j}]}.tar.gz ${list[${j}]}/ >> ${JOBLOG}manage.log
			echo "${TODAY} - ${TARGET[${i}]}/${list[${j}]} 압축 완료!!"

			mv ${list[${j}]}.tar.gz $BACKDIR${TARGET[${i}]}/ >> ${JOBLOG}manage.log
			echo "${TODAY} - mv ${list[${j}]}.tar.gz $BACKDIR${TARGET[${i}]}/" >> ${JOBLOG}manage.log
			echo "succeced...."
			
			echo "${TODAY} - /bin/rm -rf $LOGDIR${TARGET[${i}]}/${list[${j}]} 기존폴더 삭제" >> ${JOBLOG}manage.log
			/bin/rm -rf $LOGDIR${TARGET[${i}]}/${list[${j}]} >> ${JOBLOG}manage.log
		else
			echo "${TODAY} - ${TARGET[${i}]}/${list[${j}]} 압축대상 아님 "
		fi
		
	done
done

echo "${TODAY} - 삭제 작업 시작"
for ((i = 0 ; i < ${#TARGET[@]} ; i++ )) ; do
	
	echo "#######$BACKDIR${TARGET[${i}]}#######"
	list=(`ls -l $BACKDIR${TARGET[${i}]} | sed -e 's/\.tar.gz$//' | awk '{print$9}' | sort`)
	cd $BACKDIR${TARGET[${i}]}/
	echo "파일 갯수 :  ${#list[@]}"

	for ((j = 0 ; j < ${#list[@]} ; j++ )) ; do

		if [ ${list[${j}]} -le $DEL_BASE ]
		then
			echo "${TODAY} - $BACKDIR${TARGET[${i}]}/${list[${j}]} 오래된 압축 파일 삭제"
			echo "${TODAY} - /bin/rm -rf $BACKDIR${TARGET[${i}]}/${list[${j}]}.tar.gz" >> ${JOBLOG}manage.log
			/bin/rm -rf $BACKDIR${TARGET[${i}]}/${list[${j}]}.tar.gz >> ${JOBLOG}manage.log
		else
			echo "${TODAY} - $BACKDIR${TARGET[${i}]}/${list[${j}]} : ${DEL_BASE} 이내 파일"
		fi
	done
done

echo "-----------------------종료-----------------------"
