#!/bin/sh

######################################################################################

LANG=C
export LANG

alias ls=ls

HOST_NAME=`hostname`

CREATE_FILE=`hostname`"_bebore_inni_".txt


echo > $CREATE_FILE 2>&1

echo "INFO_CHKSTART"  >> $CREATE_FILE 2>&1
echo >> $CREATE_FILE 2>&1

OS=`cat /etc/redhat-release | awk '{print$3}' | cut -b1`
if [ -f /etc/redhat-release ] 
	then
		if [ $OS == 7 ]
		then
			OSVER="OS 7.x"
		else
			if [ $OS == 6 ]
			then
				OSVER="OS 6.x"
			else
				OS=`cat /etc/redhat-release | awk '{print$4}' | cut -b1`
				if [ $OS == 7 ]
				then
					OSVER="OS 7.x"
				else
					if [ $OS == 6 ]
					then
						OSVER="OS 6.x"
					else
						OS=`cat /etc/redhat-release | awk '{print$7}' | cut -b1`
						if [ $OS == 7 ]
						then
							OSVER="OS 7.x"
						else
							if [ $OS == 6 ]
							then
								OSVER="OS 6.x"
							else
								OSVER="선언되지 않은 OS"
							fi
						fi
					fi
				fi
			fi
		fi
	else
		OSVER="/etc/redhat-release 파일이 없습니다. "
	fi


echo "#########################################################"
echo "#########################################################"						>> $CREATE_FILE 2>&1
echo "o 호스트 명 : $HOST_NAME"
echo "o 호스트 명 : $HOST_NAME"															>> $CREATE_FILE 2>&1
echo "o 진단일시 : `date`"
echo "o 진단일시 : `date`"																>> $CREATE_FILE 2>&1
echo "o OS : $OSVER"
echo "o OS : $OSVER"																>> $CREATE_FILE 2>&1
echo "#########################################################"						
echo "#########################################################"						>> $CREATE_FILE 2>&1

echo " "																				
echo " "																				>> $CREATE_FILE 2>&1
echo " "																				
echo " "																				>> $CREATE_FILE 2>&1
echo " "																				
echo " "																				>> $CREATE_FILE 2>&1

echo "#################################  커널 정보   #################################" >> $CREATE_FILE 2>&1
uname -a >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

echo "###############################  디스크 볼륨 정보   #################################" >> $CREATE_FILE 2>&1
df -h >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

echo "#################################  IP 정보    ##################################" >> $CREATE_FILE 2>&1
ifconfig -a >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

echo "###############################  네트워크 현황 ###############################" >> $CREATE_FILE 2>&1
netstat -an | egrep -i "LISTEN|ESTABLISHED" >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

echo "################################## 라우팅 정보 #################################" >> $CREATE_FILE 2>&1
netstat -rn >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

echo "################################ iptables 정보 ###############################" >> $CREATE_FILE 2>&1
service iptables status >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

iptables -nL >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

echo "################################ iptables 설정파일 ###############################" >> $CREATE_FILE 2>&1
cat /etc/sysconfig/iptables >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1

echo "################################## resolv.conf 설정정보 ###############################" >> $CREATE_FILE 2>&1
cat /etc/resolv.conf >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1


echo "################################## IP interface 설정정보 ###############################" >> $CREATE_FILE 2>&1
FILES=`ifconfig -a | grep mtu | awk '{print$1}' | cut -d ':' -f1 | grep -v lo`


for file in $FILES
  do
    FILE=$file
    if [ -f /etc/sysconfig/network-scripts/ifcfg-$FILE ]
      then
		echo "################$FILE 파일 정보#############" >> $CREATE_FILE 2>&1
		ls -al /etc/sysconfig/network-scripts/ifcfg-$FILE >> $CREATE_FILE 2>&1
		echo " " >> $CREATE_FILE 2>&1
        cat /etc/sysconfig/network-scripts/ifcfg-$FILE >> $CREATE_FILE 2>&1
		echo " " >> $CREATE_FILE 2>&1
    fi
  done
  
  echo " " >> $CREATE_FILE 2>&1







echo "################################## 프로세스 현황 ###############################" >> $CREATE_FILE 2>&1
ps -ef >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1


echo "############################## 서비스 자동실행 등록 현황 ###########################" >> $CREATE_FILE 2>&1
OS=`cat /etc/redhat-release | awk '{print$3}' | cut -b1`
if [ -f /etc/redhat-release ] 
	then
		if [ $OS == 7 ]
		then
			systemctl list-unit-files >> $CREATE_FILE 2>&1
			echo " " >> $CREATE_FILE 2>&1
			IPT=`systemctl list-unit-files | grep iptables`
			FIREW=`systemctl list-unit-files | grep firewalld`
			IPTS=`systemctl status iptables`
			FIREWS=`systemctl status firewalld`
		else
			if [ $OS == 6 ]
			then
				chkconfig --list >> $CREATE_FILE 2>&1
				echo " " >> $CREATE_FILE 2>&1
				IPT=`chkconfig --list iptables`
				FIREW="OS 6.x은 사용안함"
				IPTS=`service iptables status`
				FIREWS="OS 6.x은 사용안함"
			else
				OS=`cat /etc/redhat-release | awk '{print$4}' | cut -b1`
				if [ $OS == 7 ]
				then
					systemctl list-unit-files >> $CREATE_FILE 2>&1
					echo " " >> $CREATE_FILE 2>&1
					IPT=`systemctl list-unit-files | grep iptables`
					FIREW=`systemctl list-unit-files | grep firewalld`
					IPTS=`systemctl status iptables`
					FIREWS=`systemctl status firewalld`
				else
					if [ $OS == 6 ]
					then
						chkconfig --list >> $CREATE_FILE 2>&1
						echo " " >> $CREATE_FILE 2>&1
						IPT=`chkconfig --list iptables`
						FIREW="OS 6.x은 사용안함"
						IPTS=`service iptables status`
						FIREWS="OS 6.x은 사용안함"
					else
						OS=`cat /etc/redhat-release | awk '{print$7}' | cut -b1`
						if [ $OS == 7 ]
						then
							systemctl list-unit-files >> $CREATE_FILE 2>&1
							echo " " >> $CREATE_FILE 2>&1
							IPT=`systemctl list-unit-files | grep iptables`
							FIREW=`systemctl list-unit-files | grep firewalld`
							IPTS=`systemctl status iptables`
							FIREWS=`systemctl status firewalld`
						else
							if [ $OS == 6 ]
							then
								chkconfig --list >> $CREATE_FILE 2>&1
								echo " " >> $CREATE_FILE 2>&1
								IPT=`chkconfig --list iptables`
								FIREW="OS 6.x은 사용안함"
								IPTS=`service iptables status`
								FIREWS="OS 6.x은 사용안함"
							else
								echo "선언되지 않은 OS" >> $CREATE_FILE 2>&1
								echo " " >> $CREATE_FILE 2>&1
							fi
						fi
					fi
				fi
			fi
		fi
	else
		echo "OS버전을 알수 없습니다. " >> $CREATE_FILE 2>&1
	fi



echo "################################## fstab 설정정보 ###############################" >> $CREATE_FILE 2>&1
cat /etc/fstab >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1





echo "################################## crontab 설정정보 ###############################" >> $CREATE_FILE 2>&1

list=(`ls -l /var/spool/cron/ | grep -v '합계' | awk '{print$8}'`)
echo " " >> $CREATE_FILE 2>&1
echo "crontab 설정 계정수 : ${#list[@]}"
echo " " >> $CREATE_FILE 2>&1

for ((j = 0 ; j < ${#list[@]} ; j++ )) ; do
	echo "${list[${j}]} 계정" >> $CREATE_FILE 2>&1
	cat /var/spool/cron/${list[${j}]} >> $CREATE_FILE 2>&1
	echo " " >> $CREATE_FILE 2>&1
done


echo " " >> $CREATE_FILE 2>&1


echo "################################## User ENV ###############################" >> $CREATE_FILE 2>&1
env >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1


echo "################################## 환경변수(LANG) ###############################" >> $CREATE_FILE 2>&1
if [ -f /etc/locale.conf ] 
	then
		echo "[/etc/locale.conf 파일 설정 현황]" >> $CREATE_FILE 2>&1
		cat /etc/locale.conf >> $CREATE_FILE 2>&1
		echo " " >> $CREATE_FILE 2>&1
	else
		echo "/etc/locale.conf 파일이 없습니다. " >> $CREATE_FILE 2>&1
	fi


echo "################################## 계정별 환경변수 현황###############################" >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1
HOMEDIRS=`cat /etc/passwd | awk -F":" 'length($6) > 0 {print $6}' | sort -u | grep -v '/bin/false' | grep -v 'nologin' | grep -v "#"`
FILES=".profile .bash_profile .bashrc"


  for file in $FILES
  do
    FILE=/$file
    if [ -f $FILE ]
      then
        ls -al $FILE >> $CREATE_FILE 2>&1
    fi
  done
  
  for dir in $HOMEDIRS
  do
    for file in $FILES
    do
      FILE=$dir/$file
        if [ -f $FILE ]
          then
          ls -al $FILE >> $CREATE_FILE 2>&1
		  cat $FILE >> $CREATE_FILE 2>&1
        fi
    done
  done
  echo " " >> $CREATE_FILE 2>&1



echo "################################## /etc/passwd파일 ###############################" >> $CREATE_FILE 2>&1
cat /etc/passwd >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1


echo "################################## /etc/group 파일 ###############################" >> $CREATE_FILE 2>&1
cat /etc/group >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1


echo "################################## 방화벽 관련 정보 ###############################" >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1
echo "#######iptables 자동실행 등록 현황#######" >> $CREATE_FILE 2>&1
echo "$IPT" >> $CREATE_FILE 2>&1
echo "#######firewall 자동실행 등록 현황#######" >> $CREATE_FILE 2>&1
echo "$FIREW" >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1
echo " " >> $CREATE_FILE 2>&1
echo "#######iptables 실행 확인#######" >> $CREATE_FILE 2>&1
echo "$IPTS" >> $CREATE_FILE 2>&1
echo "#######firewall 실행 확인#######" >> $CREATE_FILE 2>&1
echo "$FIREWS" >> $CREATE_FILE 2>&1

 

# "***************************************  전체 결과물 파일 생성 시작  ***********************************"

_HOSTNAME=`hostname`
CREATE_FILE_RESULT="Linux__"${_HOSTNAME}"__decode".txt
CREATE_FILE_RESULT1="Linux__"${_HOSTNAME}"__result-"`date +%Y%m%d`.txt
echo > $CREATE_FILE_RESULT

echo " "

cat $CREATE_FILE >> $CREATE_FILE_RESULT 2>&1
sed 's/$'"/`echo \\\r`/" $CREATE_FILE_RESULT > $CREATE_FILE_RESULT1
rm -rf $CREATE_FILE_RESULT 2>&1


unset FILES

unset SERVICE_INETD
unset SERVICE
unset APROC1
unset APROC
unset ACONF
unset AHOME
unset ACFILE
unset ServiceDIR
unset vsfile
unset profile
unset result

rm -rf $CREATE_FILE 2>&1

mkdir /root/ins
cp Linux__* /root/ins
rm -rf server_info.sh



